#!/bin/bash

rm -f /rw/config/EnableSecondEthernetInterface

if [ "$1" = "rj45" ]; then

    # RJ45 is the debug interface: write SFP interface name in the config file.
    sfp=$(ls -1 /sys/class/net/ | grep enp | sed -n 2p)
    echo -n $sfp > /rw/config/EnableSecondEthernetInterface

elif [ "$1" = "sfp" ]; then

    # SFP is the debug interface: write RJ45 interface name in the config file.
    rj45=$(ls -1 /sys/class/net/ | grep enp | sed -n 1p)
    echo -n $rj45 > /rw/config/EnableSecondEthernetInterface

fi

exit 0
